# Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

from libc.stdint cimport uint8_t, uint64_t, uintptr_t

cdef extern from "../includes/core.h":

    # Number of milliseconds in one second.
    const uint64_t MILLISECONDS_IN_SECOND # = 1000

    # Number of nanoseconds in one second.
    const uint64_t NANOSECONDS_IN_SECOND # = 1000000000

    # Number of nanoseconds in one millisecond.
    const uint64_t NANOSECONDS_IN_MILLISECOND # = 1000000

    # Number of nanoseconds in one microsecond.
    const uint64_t NANOSECONDS_IN_MICROSECOND # = 1000

    # Maximum capacity in characters for a [`StackStr`].
    const uintptr_t STACKSTR_CAPACITY # = 36

    # `CVec` is a C compatible struct that stores an opaque pointer to a block of
    # memory, its length and the capacity of the vector it was allocated from.
    #
    # # Safety
    #
    # Changing the values here may lead to undefined behavior when the memory is dropped.
    cdef struct CVec:
        # Opaque pointer to block of memory storing elements to access the
        # elements cast it to the underlying type.
        void *ptr;
        # The number of elements in the block.
        uintptr_t len;
        # The capacity of vector from which it was allocated.
        # Used when deallocating the memory
        uintptr_t cap;

    # Represents a Universally Unique Identifier (UUID)
    # version 4 based on a 128-bit label as specified in RFC 4122.
    cdef struct UUID4_t:
        # The UUID v4 value as a fixed-length C string byte array (includes null terminator).
        uint8_t value[37];

    # A stack-allocated ASCII string with a maximum capacity of 36 characters.
    #
    # Optimized for short identifier strings with:
    # - Stack allocation (no heap).
    # - `Copy` semantics.
    # - O(1) length access.
    # - C FFI compatibility (null-terminated).
    #
    # ASCII is required to guarantee 1 character == 1 byte, ensuring the buffer
    # always holds exactly the capacity in characters. This aligns with identifier
    # conventions which are inherently ASCII.
    #
    # # Memory Layout
    #
    # The `value` field is placed first so the struct pointer equals the string
    # pointer, making C FFI more natural: `(char*)&stack_str` works directly.
    cdef struct StackStr:
        # ASCII data with null terminator for C FFI.
        uint8_t value[37];
        # Length of the string in bytes (0-36).
        uint8_t len;
    # Maximum length in characters.
    const uintptr_t StackStr_MAX_LEN # = STACKSTR_CAPACITY

    # Construct a new *empty* [`CVec`] value for use as initialiser/sentinel in foreign code.
    CVec cvec_new();

    # Converts a UNIX nanoseconds timestamp to an ISO 8601 (RFC 3339) format C string pointer.
    const char *unix_nanos_to_iso8601_cstr(uint64_t timestamp_ns);

    # Converts a UNIX nanoseconds timestamp to an ISO 8601 (RFC 3339) format C string pointer
    # with millisecond precision.
    const char *unix_nanos_to_iso8601_millis_cstr(uint64_t timestamp_ns);

    # Converts seconds to nanoseconds (ns).
    uint64_t secs_to_nanos(double secs);

    # Converts seconds to milliseconds (ms).
    uint64_t secs_to_millis(double secs);

    # Converts milliseconds (ms) to nanoseconds (ns).
    uint64_t millis_to_nanos(double millis);

    # Converts microseconds (μs) to nanoseconds (ns).
    uint64_t micros_to_nanos(double micros);

    # Converts nanoseconds (ns) to seconds.
    double nanos_to_secs(uint64_t nanos);

    # Converts nanoseconds (ns) to milliseconds (ms).
    uint64_t nanos_to_millis(uint64_t nanos);

    # Converts nanoseconds (ns) to microseconds (μs).
    uint64_t nanos_to_micros(uint64_t nanos);

    # Return the decimal precision inferred from the given C string.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if `ptr` is null.
    uint8_t precision_from_cstr(const char *ptr);

    # Return the minimum price increment decimal precision inferred from the given C string.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if `ptr` is null.
    uint8_t min_increment_precision_from_cstr(const char *ptr);

    # Drops the C string memory at the pointer.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if `ptr` is null.
    void cstr_drop(const char *ptr);

    # Generate a new random (version-4) UUID and return it by value.
    UUID4_t uuid4_new();

    # Returns a [`UUID4`] from C string pointer.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if `ptr` cannot be cast to a valid C string.
    UUID4_t uuid4_from_cstr(const char *ptr);

    # Return a borrowed *null-terminated* UTF-8 C string representing `uuid`.
    #
    # The pointer remains valid for as long as the input `UUID4` reference lives – callers **must
    # not** attempt to free it.
    const char *uuid4_to_cstr(const UUID4_t *uuid);

    # Compare two UUID values, returning `1` when they are equal and `0` otherwise.
    uint8_t uuid4_eq(const UUID4_t *lhs, const UUID4_t *rhs);

    # Compute the stable [`u64`] hash of `uuid` using Rust’s default hasher.
    uint64_t uuid4_hash(const UUID4_t *uuid);
