# Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

from cpython.object cimport PyObject
from libc.stdint cimport uint8_t, uint32_t, uint64_t, uintptr_t
from nautilus_trader.core.rust.core cimport CVec, UUID4_t
from nautilus_trader.core.rust.model cimport TraderId_t

cdef extern from "../includes/common.h":

    # The state of a component within the system.
    cpdef enum ComponentState:
        # When a component is instantiated, but not yet ready to fulfill its specification.
        PRE_INITIALIZED # = 0,
        # When a component is able to be started.
        READY # = 1,
        # When a component is executing its actions on `start`.
        STARTING # = 2,
        # When a component is operating normally and can fulfill its specification.
        RUNNING # = 3,
        # When a component is executing its actions on `stop`.
        STOPPING # = 4,
        # When a component has successfully stopped.
        STOPPED # = 5,
        # When a component is started again after its initial start.
        RESUMING # = 6,
        # When a component is executing its actions on `reset`.
        RESETTING # = 7,
        # When a component is executing its actions on `dispose`.
        DISPOSING # = 8,
        # When a component has successfully shut down and released all of its resources.
        DISPOSED # = 9,
        # When a component is executing its actions on `degrade`.
        DEGRADING # = 10,
        # When a component has successfully degraded and may not meet its full specification.
        DEGRADED # = 11,
        # When a component is executing its actions on `fault`.
        FAULTING # = 12,
        # When a component has successfully shut down due to a detected fault.
        FAULTED # = 13,

    # A trigger condition for a component within the system.
    cpdef enum ComponentTrigger:
        # A trigger for the component to initialize.
        INITIALIZE # = 1,
        # A trigger for the component to start.
        START # = 2,
        # A trigger when the component has successfully started.
        START_COMPLETED # = 3,
        # A trigger for the component to stop.
        STOP # = 4,
        # A trigger when the component has successfully stopped.
        STOP_COMPLETED # = 5,
        # A trigger for the component to resume (after being stopped).
        RESUME # = 6,
        # A trigger when the component has successfully resumed.
        RESUME_COMPLETED # = 7,
        # A trigger for the component to reset.
        RESET # = 8,
        # A trigger when the component has successfully reset.
        RESET_COMPLETED # = 9,
        # A trigger for the component to dispose and release resources.
        DISPOSE # = 10,
        # A trigger when the component has successfully disposed.
        DISPOSE_COMPLETED # = 11,
        # A trigger for the component to degrade.
        DEGRADE # = 12,
        # A trigger when the component has successfully degraded.
        DEGRADE_COMPLETED # = 13,
        # A trigger for the component to fault.
        FAULT # = 14,
        # A trigger when the component has successfully faulted.
        FAULT_COMPLETED # = 15,

    # The log level for log messages.
    cpdef enum LogLevel:
        # The **OFF** log level. A level lower than all other log levels (off).
        OFF # = 0,
        # The **TRACE** log level. Only available in Rust for debug/development builds.
        TRACE # = 1,
        # The **DEBUG** log level.
        DEBUG # = 2,
        # The **INFO** log level.
        INFO # = 3,
        # The **WARNING** log level.
        WARNING # = 4,
        # The **ERROR** log level.
        ERROR # = 5,

    # The log color for log messages.
    cpdef enum LogColor:
        # The default/normal log color.
        NORMAL # = 0,
        # The green log color, typically used with [`LogLevel::Info`] log levels and associated with success events.
        GREEN # = 1,
        # The blue log color, typically used with [`LogLevel::Info`] log levels and associated with user actions.
        BLUE # = 2,
        # The magenta log color, typically used with [`LogLevel::Info`] log levels.
        MAGENTA # = 3,
        # The cyan log color, typically used with [`LogLevel::Info`] log levels.
        CYAN # = 4,
        # The yellow log color, typically used with [`LogLevel::Warning`] log levels.
        YELLOW # = 5,
        # The red log color, typically used with [`LogLevel::Error`] level.
        RED # = 6,

    # A real-time clock which uses system time.
    #
    # Timestamps are guaranteed to be unique and monotonically increasing.
    #
    # # Threading
    #
    # The clock holds thread-local runtime state and must remain on its originating thread.
    cdef struct LiveClock:
        pass

    # A guard that manages the lifecycle of the logging subsystem.
    #
    # `LogGuard` ensures the logging thread remains active while instances exist and properly
    # terminates when all guards are dropped. The system uses reference counting to track active
    # guards - when the last `LogGuard` is dropped, the logging thread is joined to ensure all
    # pending log messages are written before the process terminates.
    #
    # # Reference Counting
    #
    # The logging system maintains a global atomic counter of active `LogGuard` instances. This
    # ensures that:
    # - The logging thread remains active as long as at least one `LogGuard` exists.
    # - All log messages are properly flushed when intermediate guards are dropped.
    # - The logging thread is cleanly terminated and joined when the last guard is dropped.
    #
    # # Shutdown Behavior
    #
    # When the last guard is dropped, the logging thread is signaled to close, drains pending
    # messages, and is joined to ensure all logs are written before process termination.
    #
    # **Python on Windows:** Non-deterministic GC order during interpreter shutdown can
    # occasionally prevent proper thread join, resulting in truncated logs.
    #
    # # Limits
    #
    # The system supports a maximum of 255 concurrent `LogGuard` instances.
    cdef struct LogGuard:
        pass

    # A static test clock.
    #
    # Stores the current timestamp internally which can be advanced.
    #
    # # Threading
    #
    # This clock is thread-affine; use it only from the thread that created it.
    cdef struct TestClock:
        pass

    # C compatible Foreign Function Interface (FFI) for an underlying [`TestClock`].
    #
    # This struct wraps `TestClock` in a way that makes it compatible with C function
    # calls, enabling interaction with `TestClock` in a C environment.
    #
    # It implements the `Deref` trait, allowing instances of `TestClock_API` to be
    # dereferenced to `TestClock`, providing access to `TestClock`'s methods without
    # having to manually access the underlying `TestClock` instance.
    cdef struct TestClock_API:
        TestClock *_0;

    # C compatible Foreign Function Interface (FFI) for an underlying [`LiveClock`].
    #
    # This struct wraps `LiveClock` in a way that makes it compatible with C function
    # calls, enabling interaction with `LiveClock` in a C environment.
    #
    # It implements the `Deref` and `DerefMut` traits, allowing instances of `LiveClock_API` to be
    # dereferenced to `LiveClock`, providing access to `LiveClock`'s methods without
    # having to manually access the underlying `LiveClock` instance. This includes
    # both mutable and immutable access.
    cdef struct LiveClock_API:
        LiveClock *_0;

    # C compatible Foreign Function Interface (FFI) for an underlying [`LogGuard`].
    #
    # This struct wraps `LogGuard` in a way that makes it compatible with C function
    # calls, enabling interaction with `LogGuard` in a C environment.
    #
    # It implements the `Deref` trait, allowing instances of `LogGuard_API` to be
    # dereferenced to `LogGuard`, providing access to `LogGuard`'s methods without
    # having to manually access the underlying `LogGuard` instance.
    cdef struct LogGuard_API:
        LogGuard *_0;

    # Represents a time event occurring at the event timestamp.
    #
    # A `TimeEvent` carries metadata such as the event's name, a unique event ID,
    # and timestamps indicating when the event was scheduled to occur and when it was initialized.
    cdef struct TimeEvent_t:
        # The event name, identifying the nature or purpose of the event.
        char* name;
        # The unique identifier for the event.
        UUID4_t event_id;
        # UNIX timestamp (nanoseconds) when the event occurred.
        uint64_t ts_event;
        # UNIX timestamp (nanoseconds) when the instance was created.
        uint64_t ts_init;

    # FFI time event handler for Cython interoperability.
    #
    # Associates a `TimeEvent` with a callback function that is triggered
    # when the event's timestamp is reached.
    cdef struct TimeEventHandler_t:
        # The time event.
        TimeEvent_t event;
        # The callable raw pointer.
        char *callback_ptr;

    # Match a topic and a string pattern using iterative backtracking algorithm
    # pattern can contains -
    # '*' - match 0 or more characters after this
    # '?' - match any character once
    # 'a-z' - match the specific character
    #
    # # Safety
    #
    # Passing `NULL` pointers will result in a panic.
    uint8_t is_matching_ffi(const char *topic, const char *pattern);

    TestClock_API test_clock_new();

    void test_clock_drop(TestClock_API clock);

    # Registers the default callback handler for TestClock.
    #
    # # Safety
    #
    # Assumes `callback_ptr` is a valid `PyCallable` pointer.
    #
    # # Panics
    #
    # Panics if the `callback_ptr` is null or represents the Python `None` object.
    void test_clock_register_default_handler(TestClock_API *clock, PyObject *callback_ptr);

    void test_clock_set_time(const TestClock_API *clock, uint64_t to_time_ns);

    double test_clock_timestamp(const TestClock_API *clock);

    uint64_t test_clock_timestamp_ms(const TestClock_API *clock);

    uint64_t test_clock_timestamp_us(const TestClock_API *clock);

    uint64_t test_clock_timestamp_ns(const TestClock_API *clock);

    const char *test_clock_timer_names(const TestClock_API *clock);

    uintptr_t test_clock_timer_count(TestClock_API *clock);

    # # Safety
    #
    # This function assumes:
    # - `name_ptr` is a valid C string pointer.
    # - `callback_ptr` is a valid `PyCallable` pointer.
    #
    # # Panics
    #
    # Panics if `callback_ptr` is null or if setting the timer fails.
    void test_clock_set_time_alert(TestClock_API *clock,
                                   const char *name_ptr,
                                   uint64_t alert_time_ns,
                                   PyObject *callback_ptr,
                                   uint8_t allow_past);

    # # Safety
    #
    # This function assumes:
    # - `name_ptr` is a valid C string pointer.
    # - `callback_ptr` is a valid `PyCallable` pointer.
    #
    # # Parameters
    #
    # - `start_time_ns`: UNIX timestamp in nanoseconds. Use `0` to indicate "use current time".
    # - `stop_time_ns`: UNIX timestamp in nanoseconds. Use `0` to indicate "no stop time".
    #
    # # Panics
    #
    # Panics if `callback_ptr` is null or represents the Python `None` object.
    void test_clock_set_timer(TestClock_API *clock,
                              const char *name_ptr,
                              uint64_t interval_ns,
                              uint64_t start_time_ns,
                              uint64_t stop_time_ns,
                              PyObject *callback_ptr,
                              uint8_t allow_past,
                              uint8_t fire_immediately);

    # # Safety
    #
    # Assumes `set_time` is a correct `uint8_t` of either 0 or 1.
    CVec test_clock_advance_time(TestClock_API *clock, uint64_t to_time_ns, uint8_t set_time);

    # Drops a `CVec` of `TimeEventHandler_API` values.
    #
    # # Panics
    #
    # Panics if `CVec` invariants are violated (corrupted metadata).
    void vec_time_event_handlers_drop(CVec v);

    # # Safety
    #
    # Assumes `name_ptr` is a valid C string pointer.
    uint64_t test_clock_next_time(TestClock_API *clock, const char *name_ptr);

    # # Safety
    #
    # Assumes `name_ptr` is a valid C string pointer.
    void test_clock_cancel_timer(TestClock_API *clock, const char *name_ptr);

    void test_clock_cancel_timers(TestClock_API *clock);

    LiveClock_API live_clock_new();

    void live_clock_drop(LiveClock_API clock);

    # # Safety
    #
    # Assumes `callback_ptr` is a valid `PyCallable` pointer.
    #
    # # Panics
    #
    # Panics if `callback_ptr` is null or represents the Python `None` object.
    void live_clock_register_default_handler(LiveClock_API *clock, PyObject *callback_ptr);

    double live_clock_timestamp(LiveClock_API *clock);

    uint64_t live_clock_timestamp_ms(LiveClock_API *clock);

    uint64_t live_clock_timestamp_us(LiveClock_API *clock);

    uint64_t live_clock_timestamp_ns(LiveClock_API *clock);

    const char *live_clock_timer_names(const LiveClock_API *clock);

    uintptr_t live_clock_timer_count(LiveClock_API *clock);

    # # Safety
    #
    # This function assumes:
    # - `name_ptr` is a valid C string pointer.
    # - `callback_ptr` is a valid `PyCallable` pointer.
    #
    # # Panics
    #
    # This function panics if:
    # - `name` is not a valid string.
    # - `callback_ptr` is NULL and no default callback has been assigned on the clock.
    void live_clock_set_time_alert(LiveClock_API *clock,
                                   const char *name_ptr,
                                   uint64_t alert_time_ns,
                                   PyObject *callback_ptr,
                                   uint8_t allow_past);

    # # Safety
    #
    # This function assumes:
    # - `name_ptr` is a valid C string pointer.
    # - `callback_ptr` is a valid `PyCallable` pointer.
    #
    # # Parameters
    #
    # - `start_time_ns`: UNIX timestamp in nanoseconds. Use `0` to indicate "use current time".
    # - `stop_time_ns`: UNIX timestamp in nanoseconds. Use `0` to indicate "no stop time".
    #
    # # Panics
    #
    # This function panics if:
    # - `name` is not a valid string.
    # - `callback_ptr` is NULL and no default callback has been assigned on the clock.
    void live_clock_set_timer(LiveClock_API *clock,
                              const char *name_ptr,
                              uint64_t interval_ns,
                              uint64_t start_time_ns,
                              uint64_t stop_time_ns,
                              PyObject *callback_ptr,
                              uint8_t allow_past,
                              uint8_t fire_immediately);

    # # Safety
    #
    # Assumes `name_ptr` is a valid C string pointer.
    uint64_t live_clock_next_time(LiveClock_API *clock, const char *name_ptr);

    # # Safety
    #
    # Assumes `name_ptr` is a valid C string pointer.
    void live_clock_cancel_timer(LiveClock_API *clock, const char *name_ptr);

    void live_clock_cancel_timers(LiveClock_API *clock);

    const char *component_state_to_cstr(ComponentState value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if the input C string does not match a valid enum variant.
    ComponentState component_state_from_cstr(const char *ptr);

    const char *component_trigger_to_cstr(ComponentTrigger value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if the input C string does not match a valid enum variant.
    ComponentTrigger component_trigger_from_cstr(const char *ptr);

    const char *log_level_to_cstr(LogLevel value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if the input C string does not match a valid enum variant.
    LogLevel log_level_from_cstr(const char *ptr);

    const char *log_color_to_cstr(LogColor value);

    # Returns an enum from a Python string.
    #
    # # Safety
    #
    # Assumes `ptr` is a valid C string pointer.
    #
    # # Panics
    #
    # Panics if the input C string does not match a valid enum variant.
    LogColor log_color_from_cstr(const char *ptr);

    # Initializes logging.
    #
    # Logging should be used for Python and sync Rust logic which is most of
    # the components in the [nautilus_trader](https://pypi.org/project/nautilus_trader) package.
    # Logging can be configured to filter components and write up to a specific level only
    # by passing a configuration using the `NAUTILUS_LOG` environment variable.
    #
    # # Safety
    #
    # Should only be called once during an application's run, ideally at the
    # beginning of the run.
    #
    # This function assumes:
    # - `directory_ptr` is either NULL or a valid C string pointer.
    # - `file_name_ptr` is either NULL or a valid C string pointer.
    # - `file_format_ptr` is either NULL or a valid C string pointer.
    # - `component_level_ptr` is either NULL or a valid C string pointer.
    #
    # # Panics
    #
    # Panics if initializing the Rust logger fails.
    LogGuard_API logging_init(TraderId_t trader_id,
                              UUID4_t instance_id,
                              LogLevel level_stdout,
                              LogLevel level_file,
                              const char *directory_ptr,
                              const char *file_name_ptr,
                              const char *file_format_ptr,
                              const char *component_levels_ptr,
                              uint8_t is_colored,
                              uint8_t is_bypassed,
                              uint8_t print_config,
                              uint8_t log_components_only,
                              uint64_t max_file_size,
                              uint32_t max_backup_count);

    # Creates a new log event.
    #
    # # Safety
    #
    # This function assumes:
    # - `component_ptr` is a valid C string pointer.
    # - `message_ptr` is a valid C string pointer.
    void logger_log(LogLevel level,
                    LogColor color,
                    const char *component_ptr,
                    const char *message_ptr);

    # Logs the Nautilus system header.
    #
    # # Safety
    #
    # This function assumes:
    # - `machine_id_ptr` is a valid C string pointer.
    # - `component_ptr` is a valid C string pointer.
    void logging_log_header(TraderId_t trader_id,
                            const char *machine_id_ptr,
                            UUID4_t instance_id,
                            const char *component_ptr);

    # Logs system information.
    #
    # # Safety
    #
    # Assumes `component_ptr` is a valid C string pointer.
    void logging_log_sysinfo(const char *component_ptr);

    # Flushes global logger buffers of any records.
    void logger_flush();

    # Flushes global logger buffers of any records and then drops the logger.
    void logger_drop(LogGuard_API log_guard);

    uint8_t logging_is_initialized();

    void logging_set_bypass();

    void logging_shutdown();

    uint8_t logging_is_colored();

    void logging_clock_set_realtime_mode();

    void logging_clock_set_static_mode();

    void logging_clock_set_static_time(uint64_t time_ns);

    # Drops a `TimeEventHandler_API`, releasing any Python callback reference.
    #
    # # Safety
    #
    # The handler must be valid and not previously dropped.
    void time_event_handler_drop(TimeEventHandler_t handler);

    # # Safety
    #
    # Assumes `name_ptr` is borrowed from a valid Python UTF-8 `str`.
    TimeEvent_t time_event_new(const char *name_ptr,
                               UUID4_t event_id,
                               uint64_t ts_event,
                               uint64_t ts_init);

    # Returns a [`TimeEvent`] as a C string pointer.
    const char *time_event_to_cstr(const TimeEvent_t *event);

    TimeEventHandler_t dummy(TimeEventHandler_t v);
