# -------------------------------------------------------------------------------------------------
#  Copyright (C) 2015-2026 Nautech Systems Pty Ltd. All rights reserved.
#  https://nautechsystems.io
#
#  Licensed under the GNU Lesser General Public License Version 3.0 (the "License");
#  You may not use this file except in compliance with the License.
#  You may obtain a copy of the License at https://www.gnu.org/licenses/lgpl-3.0.en.html
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
# -------------------------------------------------------------------------------------------------

from __future__ import annotations

from typing import Final

from nautilus_trader.core import nautilus_pyo3
from nautilus_trader.model.identifiers import ClientId
from nautilus_trader.model.identifiers import Venue


HYPERLIQUID: Final[str] = "HYPERLIQUID"
HYPERLIQUID_VENUE: Final[Venue] = Venue(HYPERLIQUID)
HYPERLIQUID_CLIENT_ID: Final[ClientId] = ClientId(HYPERLIQUID)

# Error message substrings for detecting specific rejection reasons
HYPERLIQUID_POST_ONLY_WOULD_MATCH: Final[str] = nautilus_pyo3.HYPERLIQUID_POST_ONLY_WOULD_MATCH
HYPERLIQUID_BUILDER_FEE_NOT_APPROVED: Final[str] = (
    nautilus_pyo3.HYPERLIQUID_BUILDER_FEE_NOT_APPROVED
)
